const otpModel = require("../models/otpModel");

const createOTP = async (req) => {
    let { email } = req.body;
    email = email?.toLowerCase();
    const otp = Math.floor(1000 + Math.random() * 9000).toString();
    const newOTP = new otpModel({
        email: email,
        OTP: otp
    });
    const result = await newOTP.save();
    return result
};

const verifyOTP = async (req) => {
    const { email, OTP } = req.body;
    const otp = await otpModel.findOne({ email, OTP });
    return otp
};

module.exports = {
    createOTP,
    verifyOTP
};